﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.AHOBPR.BLL;
using VIRP.AHOBPR.BO;
using VIRP_WEB.Custom.BPR;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class UserControlAllDeployments : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }
        private int GetCurrentRegistryId()
        {
            Control baseControl = Parent;
            BprBasePage basePage = baseControl.Page as BprBasePage;
            if (basePage != null)
                return basePage.UserSession.CurrentRegistryId;

            return default(int);
        }

        public void LoadUserControl(int registrantId)
        {
            HiddenFieldRegistrantId.Value = registrantId.ToString();
            List<REGISTRANT_DEPLOYMENT> deployments = REGISTRANT_DEPLOYMENTManager.GetItemsByRegistrantId(HttpContext.Current.User.Identity.Name, GetCurrentRegistryId(), registrantId);
            GridViewDeploymentHistory.DataSource = deployments;
            GridViewDeploymentHistory.DataBind();

            REGISTRANT registrant = REGISTRANTManager.GetItem(HttpContext.Current.User.Identity.Name, GetCurrentRegistryId(), registrantId);
            LabelPre911.Text = registrant.PRE_911_DEPLOYMENT;
            LabelPost911.Text = registrant.POST_911_DEPLOYMENT;

            if (DropDownListLocation.Items.Count == 1 && deployments.Count() > 0)
            {
                //Load location dropdown list
                List<KeyValuePair<string, string>> locations = (from d in deployments
                                                                orderby d.DEPLOYMENT_COUNTRY
                                                                select new KeyValuePair<string, string>(d.DEPLOYMENT_COUNTRY, d.DEPLOYMENT_COUNTRY)).Distinct().ToList();
                DropDownListLocation.DataSource = locations;
                DropDownListLocation.DataValueField = "Key";
                DropDownListLocation.DataTextField = "Value";
                DropDownListLocation.DataBind();

                //Load data source dropdown list
                List<KeyValuePair<string, string>> sources = (from d in deployments
                                                              orderby d.DEPLOYMENT_UIC
                                                              select new KeyValuePair<string, string>(d.DEPLOYMENT_UIC, d.DEPLOYMENT_UIC)).Distinct().ToList();
                DropDownListSource.DataSource = sources;
                DropDownListSource.DataValueField = "Key";
                DropDownListSource.DataTextField = "Value";
                DropDownListSource.DataBind();

                //Load deployment stage dropdown list
                List<KeyValuePair<string, string>> stages = (from d in deployments
                                                             orderby d.DUTY_PROJECT_CODE
                                                             select new KeyValuePair<string, string>(d.DUTY_PROJECT_CODE, d.DUTY_PROJECT_CODE)).Distinct().ToList();
                DropDownListStage.DataSource = stages;
                DropDownListStage.DataValueField = "Key";
                DropDownListStage.DataTextField = "Value";
                DropDownListStage.DataBind();
            }

        }
         
        public string NavigationSource { get; set; }

        protected void ButtonFilter_Click(object sender, EventArgs e)
        {
            List<REGISTRANT_DEPLOYMENT> deployments = REGISTRANT_DEPLOYMENTManager.GetItemsByRegistrantId(HttpContext.Current.User.Identity.Name, GetCurrentRegistryId(), Int32.Parse(HiddenFieldRegistrantId.Value));
            if (!string.IsNullOrEmpty(DropDownListLocation.Text) && DropDownListLocation.Text != "All")
            {
                deployments = (from d in deployments where d.DEPLOYMENT_COUNTRY == DropDownListLocation.Text select d).ToList();
            }
            if (!string.IsNullOrEmpty(DropDownListSource.Text) && DropDownListSource.Text != "All")
            {
                deployments = (from d in deployments where d.DEPLOYMENT_UIC == DropDownListSource.Text select d).ToList();
            }
            if (!string.IsNullOrEmpty(DropDownListStage.Text) && DropDownListStage.Text != "All")
            {
                deployments = (from d in deployments where d.DUTY_PROJECT_CODE == DropDownListStage.Text select d).ToList();
            }
            GridViewDeploymentHistory.DataSource = deployments;
            GridViewDeploymentHistory.DataBind();

        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            this.DropDownListLocation.SelectedIndex = -1;
            this.DropDownListSource.SelectedIndex = -1;
            this.DropDownListStage.SelectedIndex = -1;
        }
    }
}